varying vec2 	texcoord;
uniform float 	time;

float Pi=3.14159265359;

void main()
{	
	vec2 pos=(texcoord.st-0.5)*vec2(2000.0);

	///////////////////////// Build wave ////////////////////////////////////////////
	float A = 100.0;													// amplitude
	vec2 D = normalize(vec2(0.0,1.0));									// DIRECTION basing on wind vector
	float L = 2000.0;													// wavelength
	float k = 2200.0*Pi/L;												// frequency
	
	float w = 2.0*Pi/L;		
	float Q = 2.0/(w*A);
	float dotD = dot(pos, D);
	float C = cos(w*dotD + k*time);
	float S = sin(w*dotD + k*time + 200.0);
	
	vec3 outwave=vec3(0.0,0.0,0.0);
	#ifdef HEIGHTS
		outwave = vec3(Q*A*C*D.x, A * S, Q*A*C*D.y);
	#endif
	
	#ifdef NORMALS
		outwave = vec3(-D.x*w*A*C, Q*w*A*S ,-D.y*w*A*C);
	#endif
	
	gl_FragColor.xyz = outwave;
	gl_FragColor.a=1.0;
}